rm(list=ls())
library(yarrr); library(MuMIn)

## Import the raw salmon respiration data
data <- read.csv("trout_feeding.csv")
boltz <- 0.00008617343
T0 <- 273.15 + 10   ## Mean temperature of the respiration experiments
data$temp.kT <- ((273.15+data$temp)-T0)/(boltz*(273.15+data$temp)*T0)
data$acclimation <- c("cold","warm","warm")[match(data$fish,c(12,1,5))]
data$acclimation3 <- c("cold","tepid","warm")[match(data$fish,c(12,1,5))]
data$col <- c("blue","red","red")[match(data$fish,c(12,1,5))]
data$col3 <- c("blue","orange","red")[match(data$fish,c(12,1,5))]
data$pch <- c(16,17,17)[match(data$fish,c(12,1,5))]
data$pch3 <- c(16,17,18)[match(data$fish,c(12,1,5))]
rad <- data[data$prey=="radix",]
sim <- data[data$prey=="simuliidae",]

## Radix models including acclimation
m1.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation + temp.kT:acclimation + log(mass):temp.kT:acclimation, data=rad)
m2.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation + temp.kT:acclimation, data=rad)
m3.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation, data=rad)
m4.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + temp.kT:acclimation, data=rad)
m5.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):acclimation + temp.kT:acclimation, data=rad)
m6.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT, data=rad)
m7.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + log(mass):temp.kT, data=rad)
m8.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):acclimation, data=rad)
m9.rad <- lm(log(feeding+1) ~ log(mass) + acclimation + log(mass):acclimation, data=rad)
m10.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + temp.kT:acclimation, data=rad)
m11.rad <- lm(log(feeding+1) ~ temp.kT + acclimation + temp.kT:acclimation, data=rad)
m12.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation, data=rad)
m13.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT, data=rad)
m14.rad <- lm(log(feeding+1) ~ log(mass) + acclimation, data=rad)
m15.rad <- lm(log(feeding+1) ~ temp.kT + acclimation, data=rad)
m16.rad <- lm(log(feeding+1) ~ log(mass), data=rad)
m17.rad <- lm(log(feeding+1) ~ temp.kT, data=rad)
m18.rad <- lm(log(feeding+1) ~ acclimation, data=rad)
m19.rad <- lm(log(feeding+1) ~ 1, data=rad)
aic.rad <- AICc(m1.rad,m2.rad,m3.rad,m4.rad,m5.rad,m6.rad,m7.rad,m8.rad,m9.rad,m10.rad,m11.rad,m12.rad,m13.rad,m14.rad,m15.rad,m16.rad,m17.rad,m18.rad,m19.rad)
aic.rad$dAIC <- data.frame(aic.rad[2] - min(aic.rad[2]))$AIC; aic.rad
summary(m11.rad); anova(m11.rad)
new.rad <- data.frame(temp.kT=rep(seq(min(rad$temp.kT), max(rad$temp.kT), length.out=100),2), acclimation=c(rep("cold",100),rep("warm",100)))
p.rad <- data.frame(predict(m11.rad, newdata=new.rad, interval="confidence"))
p.rad.cold <- p.rad[1:100,]; p.rad.warm <- p.rad[101:200,]

## Simulium models including acclimation
m1.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation + temp.kT:acclimation + log(mass):temp.kT:acclimation, data=sim)
m2.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation + temp.kT:acclimation, data=sim)
m3.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation, data=sim)
m4.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + temp.kT:acclimation, data=sim)
m5.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):acclimation + temp.kT:acclimation, data=sim)
m6.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT, data=sim)
m7.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + log(mass):temp.kT, data=sim)
m8.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + log(mass):acclimation, data=sim)
m9.sim <- lm(log(feeding+1) ~ log(mass) + acclimation + log(mass):acclimation, data=sim)
m10.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation + temp.kT:acclimation, data=sim)
m11.sim <- lm(log(feeding+1) ~ temp.kT + acclimation + temp.kT:acclimation, data=sim)
m12.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation, data=sim)
m13.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT, data=sim)
m14.sim <- lm(log(feeding+1) ~ log(mass) + acclimation, data=sim)
m15.sim <- lm(log(feeding+1) ~ temp.kT + acclimation, data=sim)
m16.sim <- lm(log(feeding+1) ~ log(mass), data=sim)
m17.sim <- lm(log(feeding+1) ~ temp.kT, data=sim)
m18.sim <- lm(log(feeding+1) ~ acclimation, data=sim)
m19.sim <- lm(log(feeding+1) ~ 1, data=sim)
aic.sim <- AICc(m1.sim,m2.sim,m3.sim,m4.sim,m5.sim,m6.sim,m7.sim,m8.sim,m9.sim,m10.sim,m11.sim,m12.sim,m13.sim,m14.sim,m15.sim,m16.sim,m17.sim,m18.sim,m19.sim)
aic.sim$dAIC <- data.frame(aic.sim[2] - min(aic.sim[2]))$AIC; aic.sim
summary(m11.sim); anova(m11.sim)
new.sim <- data.frame(temp.kT=rep(seq(min(sim$temp.kT), max(sim$temp.kT), length.out=100),2), acclimation=c(rep("cold",100),rep("warm",100)))
p.sim <- data.frame(predict(m11.sim, newdata=new.sim, interval="confidence"))
p.sim.cold <- p.sim[1:100,]; p.sim.warm <- p.sim[101:200,]

## Saving statistical output and figures
write.table(as.matrix(c("Radix balthica", "", capture.output(aic.rad), capture.output(summary(m11.rad)), capture.output(anova(m11.rad)), "",
                        "Simulium vittatum", "", capture.output(aic.sim), capture.output(summary(m11.sim)), capture.output(anova(m11.sim)))),
            "Trout feeding rate.txt", row.names=F, col.names=F, quote=F)

tiff("Trout feeding rate.tif",16,8,pointsize=10,units="cm",res=600,compression="lzw")
par(mar=c(4.5,4.5,1,1), mfrow=c(1,2))
plot(log(feeding+1) ~ temp, pch=pch, col=transparent(col, trans.val=0.3), data=rad, xlab="", ylab="")
xval <- seq(min(rad$temp), max(rad$temp), length.out=100)
polygon(c(xval, rev(xval)), c(p.rad.cold$lwr, rev(p.rad.cold$upr)), col=adjustcolor("blue",alpha.f=0.25),  border = NA)
lines(xval, p.rad.cold$fit, col="blue", lwd=2, lty=1)
polygon(c(xval, rev(xval)), c(p.rad.warm$lwr, rev(p.rad.warm$upr)), col=adjustcolor("red",alpha.f=0.25),  border = NA)
lines(xval, p.rad.warm$fit, col="red", lwd=2, lty=2)
mtext(quote(Temperature~("C")), side=1, line=3)
mtext(quote(Ln~feeding~rate~(individuals~h^-1)), side=2, line=3)
mtext("(a)", side=3, font=2, line=-1.2, adj=0.02)

plot(log(feeding+1) ~ temp, pch=pch, col=transparent(col, trans.val=0.3), data=sim, xlab="", ylab="")
polygon(c(xval, rev(xval)), c(p.sim.cold$lwr, rev(p.sim.cold$upr)), col=adjustcolor("blue",alpha.f=0.25),  border = NA)
lines(xval, p.sim.cold$fit, col="blue", lwd=2, lty=1)
polygon(c(xval, rev(xval)), c(p.sim.warm$lwr, rev(p.sim.warm$upr)), col=adjustcolor("red",alpha.f=0.25),  border = NA)
lines(xval, p.sim.warm$fit, col="red", lwd=2, lty=2)
mtext(quote(Temperature~("C")), side=1, line=3)
mtext(quote(Ln~feeding~rate~(individuals~h^-1)), side=2, line=3)
mtext("(b)", side=3, font=2, line=-1.2, adj=0.02)
legend("bottomright", legend=c("cold (IS12)","warm (IS1+IS5)"), pch=16:17, col=c("blue","red"), lty=1:2, cex=0.9)
dev.off()


## Radix models including acclimation with three levels
m1.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3 + temp.kT:acclimation3 + log(mass):temp.kT:acclimation3, data=rad)
m2.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3 + temp.kT:acclimation3, data=rad)
m3.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3, data=rad)
m4.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + temp.kT:acclimation3, data=rad)
m5.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):acclimation3 + temp.kT:acclimation3, data=rad)
m6.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT, data=rad)
m7.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + log(mass):temp.kT, data=rad)
m8.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):acclimation3, data=rad)
m9.rad <- lm(log(feeding+1) ~ log(mass) + acclimation3 + log(mass):acclimation3, data=rad)
m10.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + temp.kT:acclimation3, data=rad)
m11.rad <- lm(log(feeding+1) ~ temp.kT + acclimation3 + temp.kT:acclimation3, data=rad)
m12.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3, data=rad)
m13.rad <- lm(log(feeding+1) ~ log(mass) + temp.kT, data=rad)
m14.rad <- lm(log(feeding+1) ~ log(mass) + acclimation3, data=rad)
m15.rad <- lm(log(feeding+1) ~ temp.kT + acclimation3, data=rad)
m16.rad <- lm(log(feeding+1) ~ log(mass), data=rad)
m17.rad <- lm(log(feeding+1) ~ temp.kT, data=rad)
m18.rad <- lm(log(feeding+1) ~ acclimation3, data=rad)
m19.rad <- lm(log(feeding+1) ~ 1, data=rad)
aic.rad <- AICc(m1.rad,m2.rad,m3.rad,m4.rad,m5.rad,m6.rad,m7.rad,m8.rad,m9.rad,m10.rad,m11.rad,m12.rad,m13.rad,m14.rad,m15.rad,m16.rad,m17.rad,m18.rad,m19.rad)
aic.rad$dAIC <- data.frame(aic.rad[2] - min(aic.rad[2]))$AIC; aic.rad
summary(m11.rad); anova(m11.rad)
new.rad <- data.frame(temp.kT=rep(seq(min(rad$temp.kT), max(rad$temp.kT), length.out=100),3), acclimation3=c(rep("cold",100),rep("tepid",100),rep("warm",100)))
p.rad <- data.frame(predict(m11.rad, newdata=new.rad, interval="confidence"))
p.rad.cold <- p.rad[1:100,]; p.rad.tepid <- p.rad[101:200,]; p.rad.warm <- p.rad[201:300,]

## Simulium models including acclimation with three levels
m1.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3 + temp.kT:acclimation3 + log(mass):temp.kT:acclimation3, data=sim)
m2.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3 + temp.kT:acclimation3, data=sim)
m3.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3, data=sim)
m4.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + temp.kT:acclimation3, data=sim)
m5.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):acclimation3 + temp.kT:acclimation3, data=sim)
m6.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT, data=sim)
m7.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + log(mass):temp.kT, data=sim)
m8.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + log(mass):acclimation3, data=sim)
m9.sim <- lm(log(feeding+1) ~ log(mass) + acclimation3 + log(mass):acclimation3, data=sim)
m10.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3 + temp.kT:acclimation3, data=sim)
m11.sim <- lm(log(feeding+1) ~ temp.kT + acclimation3 + temp.kT:acclimation3, data=sim)
m12.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT + acclimation3, data=sim)
m13.sim <- lm(log(feeding+1) ~ log(mass) + temp.kT, data=sim)
m14.sim <- lm(log(feeding+1) ~ log(mass) + acclimation3, data=sim)
m15.sim <- lm(log(feeding+1) ~ temp.kT + acclimation3, data=sim)
m16.sim <- lm(log(feeding+1) ~ log(mass), data=sim)
m17.sim <- lm(log(feeding+1) ~ temp.kT, data=sim)
m18.sim <- lm(log(feeding+1) ~ acclimation3, data=sim)
m19.sim <- lm(log(feeding+1) ~ 1, data=sim)
aic.sim <- AICc(m1.sim,m2.sim,m3.sim,m4.sim,m5.sim,m6.sim,m7.sim,m8.sim,m9.sim,m10.sim,m11.sim,m12.sim,m13.sim,m14.sim,m15.sim,m16.sim,m17.sim,m18.sim,m19.sim)
aic.sim$dAIC <- data.frame(aic.sim[2] - min(aic.sim[2]))$AIC; aic.sim
summary(m11.sim); anova(m11.sim)
new.sim <- data.frame(temp.kT=rep(seq(min(sim$temp.kT), max(sim$temp.kT), length.out=100),3), acclimation3=c(rep("cold",100),rep("tepid",100),rep("warm",100)))
p.sim <- data.frame(predict(m11.sim, newdata=new.sim, interval="confidence"))
p.sim.cold <- p.sim[1:100,]; p.sim.tepid <- p.sim[101:200,]; p.sim.warm <- p.sim[201:300,]

## Saving statistical output and figures
write.table(as.matrix(c("Radix balthica", "", capture.output(aic.rad), capture.output(summary(m11.rad)), capture.output(anova(m11.rad)), "",
                        "Simulium vittatum", "", capture.output(aic.sim), capture.output(summary(m11.sim)), capture.output(anova(m11.sim)))),
            "Trout feeding rate (3).txt", row.names=F, col.names=F, quote=F)

tiff("Trout feeding rate (3).tif",16,8,pointsize=10,units="cm",res=600,compression="lzw")
par(mar=c(4.5,4.5,1,1), mfrow=c(1,2))
plot(log(feeding+1) ~ temp, pch=pch, col=transparent(col3, trans.val=0.3), data=rad, xlab="", ylab="")
xval <- seq(min(rad$temp), max(rad$temp), length.out=100)
polygon(c(xval, rev(xval)), c(p.rad.cold$lwr, rev(p.rad.cold$upr)), col=adjustcolor("blue",alpha.f=0.25),  border = NA)
lines(xval, p.rad.cold$fit, col="blue", lwd=2, lty=1)
polygon(c(xval, rev(xval)), c(p.rad.tepid$lwr, rev(p.rad.tepid$upr)), col=adjustcolor("orange",alpha.f=0.25),  border = NA)
lines(xval, p.rad.tepid$fit, col="orange", lwd=2, lty=2)
polygon(c(xval, rev(xval)), c(p.rad.warm$lwr, rev(p.rad.warm$upr)), col=adjustcolor("red",alpha.f=0.25),  border = NA)
lines(xval, p.rad.warm$fit, col="red", lwd=2, lty=3)
mtext(quote(Temperature~("C")), side=1, line=3)
mtext(quote(Ln~feeding~rate~(individuals~h^-1)), side=2, line=3)
mtext("(a)", side=3, font=2, line=-1.2, adj=0.02)

plot(log(feeding+1) ~ temp, pch=pch, col=transparent(col3, trans.val=0.3), data=sim, xlab="", ylab="")
polygon(c(xval, rev(xval)), c(p.sim.cold$lwr, rev(p.sim.cold$upr)), col=adjustcolor("blue",alpha.f=0.25),  border = NA)
lines(xval, p.sim.cold$fit, col="blue", lwd=2, lty=1)
polygon(c(xval, rev(xval)), c(p.sim.tepid$lwr, rev(p.sim.tepid$upr)), col=adjustcolor("orange",alpha.f=0.25),  border = NA)
lines(xval, p.sim.tepid$fit, col="orange", lwd=2, lty=2)
polygon(c(xval, rev(xval)), c(p.sim.warm$lwr, rev(p.sim.warm$upr)), col=adjustcolor("red",alpha.f=0.25),  border = NA)
lines(xval, p.sim.warm$fit, col="red", lwd=2, lty=3)
mtext(quote(Temperature~("C")), side=1, line=3)
mtext(quote(Ln~feeding~rate~(individuals~h^-1)), side=2, line=3)
mtext("(b)", side=3, font=2, line=-1.2, adj=0.02)
legend("bottomright", legend=c("cold (IS12)","warm (IS1)","warm (IS5)"), pch=16:18, col=c("blue","orange","red"), lty=1:3, cex=0.9)
dev.off()
